unit TrdSingleRun;

interface
uses IBAccess, Classes, SysUtils;

type
  TSingleRunThread = class(TThread)
  private
    FDb: TIBSqlQuery;
    FRtnArray: T2dString;
    FDbQuery: string;
    FDone: boolean;
    function GetRtnArray: T2dString;
    procedure SetDbQuery(const Value: string);
  protected
    procedure Execute; override;
  public
    Destructor Destroy;override;
    property DbQuery: string read FDbQuery write SetDbQuery;
    property RtnArray: T2dString read GetRtnArray write FRtnArray;
  end;


implementation

{ TSingleRunThread }

destructor TSingleRunThread.Destroy;
begin
  FDb.Free;
  inherited;
end;

procedure TSingleRunThread.Execute;
begin
  //inherited;
  FreeOnTerminate := True;
  try
    FDb := TIBSqlQuery.Create;
    Fdb.PopulateArray(FDbQuery, FRtnArray);
  except
    on E: Exception do
    begin
      FDbQuery := '<' + FDbQuery + '> Caused Error :: ' + E.message;
      SetLength(FRtnArray, 0);
    end;
  end;
  FDone := true;
end;


function TSingleRunThread.GetRtnArray: T2dString;
begin
  if not FDone then result := nil
  else
    Result := FRtnArray;
end;

procedure TSingleRunThread.SetDbQuery(const Value: string);
begin
  if not Suspended then raise Exception.Create('Cannot add Query once running');

  FDbQuery := Value;
end;

end.

